<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Technician extends Model 
{

    protected $table = 'technicians';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function ratings()
    {
        return $this->hasMany('\TechnicianRating', 'technician_id');
    }

}